/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.service.serviceableevent;

import com.ibm.hwmca.base.pa.ar.XMLHelper;
import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.service.serviceableevent.ServiceableEventPersistentData;
import com.ibm.hwmca.fw.service.serviceaction.ServiceAction;
import com.ibm.hwmca.fw.util.UUIDFactory;
import org.w3c.dom.Node;

public abstract class ServiceableEvent
implements Persistable {
    private String uniqueKey = null;
    private transient ServiceAction serviceAction = null;
    private boolean hasServiceAction = false;
    private static final String uniqueKeyXML = "ukey";

    public ServiceableEvent() {
        this.uniqueKey = UUIDFactory.generate().toString();
    }

    public ServiceableEvent(PersistentData pd) {
        this.uniqueKey = ((ServiceableEventPersistentData)pd).uniqueKey;
        this.hasServiceAction = ((ServiceableEventPersistentData)pd).hasServiceAction;
    }

    public PersistentData getPersistentData() {
        ServiceableEventPersistentData pd = new ServiceableEventPersistentData();
        pd.uniqueKey = this.uniqueKey;
        pd.hasServiceAction = this.hasServiceAction;
        return pd;
    }

    public ServiceableEvent(Node xfProblem) {
        this.fromXML(xfProblem);
    }

    public final String getUniqueKey() {
        return this.uniqueKey;
    }

    public ServiceAction getServiceAction() {
        return this.serviceAction;
    }

    public void setServiceAction(ServiceAction serviceAction) {
        this.serviceAction = serviceAction;
        this.hasServiceAction = serviceAction != null;
    }

    public boolean hasServiceAction() {
        return this.hasServiceAction;
    }

    protected void fromXML(Node xfProblem) {
        this.uniqueKey = XMLHelper.getRealValue(XMLHelper.getWorkSection(xfProblem, uniqueKeyXML));
    }

    public boolean isHasServiceAction() {
        return this.hasServiceAction;
    }

    public void setHasServiceAction(boolean hasServiceAction) {
        this.hasServiceAction = hasServiceAction;
    }
}

